
library(dplyr)
library(stringr)
library(lemis)

amphiData <- read.csv(file = "./Data/AmphibiaWeb Data Trade Augmented.csv",
                      stringsAsFactors = FALSE)
lemisData <- read.csv(file = "./Data/LEMISData/LEMIS_amphibian_data.csv",
                      stringsAsFactors = FALSE)

lemisData <- lemisData %>% 
  mutate(lemisName = str_to_sentence(paste(genus, species))) # %>% 
  # filter(!str_detect(lemisName, "sp\\.$") & !lemisName == "NA NA")

# create a vector of names then check if they appear in the LEMIS database
amphiData$lemisName <- apply(amphiData, 1, function(x){
  nms <- c(x["amphiName"], x["synonymies"])
  nms <- nms[!nms == ""]
  return(ifelse(any(nms %in% lemisData$lemisName),
                lemisData$lemisName[lemisData$lemisName %in% nms],
                FALSE))
})

lemisData$amphiName <- apply(lemisData, 1, function(x){
  amphiData$amphiName[amphiData$lemisName == x["lemisName"]][1]
})

lemis_codes() %>% 
  filter(field == "description")

# how many items are seized
lemisData %>% 
  filter(description %in% c("BOD", "EGL", "DEA", "LIV", "SPE", "SKI", "TRO")) %>% 
  mutate(seized = disposition == "S") %>% 
  group_by(seized) %>% 
  summarise(nItems = sum(quantity)) %>% 
  ungroup() %>% 
  mutate(totItems = sum(nItems),
         per = nItems / totItems *100)
  
lemis_codes() %>% 
  filter(field == "purpose")
# Limit summaries to items that are actually representative of entire individuals
# item filter == description %in% c("BOD", "EGL", "DEA", "LIV", "SPE", "SKI", "TRO"))

# How much of the LEMIS trade is commercial
lemisData %>% 
  filter(description %in% c("BOD", "EGL", "DEA", "LIV", "SPE", "SKI", "TRO")) %>% 
  mutate(nonComm = ifelse(purpose %in% c("M", "S", "Y"), "NonComm", "Comm")) %>% 
  group_by(nonComm) %>% 
  summarise(nItems = sum(quantity)) %>% 
  ungroup() %>% 
  mutate(totItems = sum(nItems),
         per = nItems / totItems *100)

lemis_codes() %>% 
  filter(field == "source")
# How much of the trade is coming from wild versus wild capture
lemisData %>% 
  filter(description %in% c("BOD", "EGL", "DEA", "LIV", "SPE", "SKI", "TRO")) %>% 
  mutate(originSimp = case_when(
    source %in% c("C", "D", "F", "R") ~ "Captive",
    source == "W" ~ "Wild",
    TRUE ~ "Other"
  )) %>% 
  group_by(originSimp) %>% 
  summarise(nItems = sum(quantity)) %>% 
  ungroup() %>% 
  mutate(totItems = sum(nItems),
         per = nItems / totItems *100)
